/*
   This program echos lines from stdin to stdout but
   it converts all the letters to upper case.

   This version has a 5 second delay between each read
   from stdin and each write to stdout. This simulates
   a filter that has a lot of "work" to do.
*/
import java.util.Scanner;

public class ToUpperCaseDelayed
{
   public static void main(String[] args) throws InterruptedException
   {
      // Create a Scanner object to make it easier to use System.in
      Scanner scanner = new Scanner( System.in );

      while ( scanner.hasNextLine() )
      {
         String oneLine = scanner.nextLine();
         Thread.sleep(5000); // pretend to be busy for 5 seconds
         System.out.println( oneLine.toUpperCase() );
      }
   }
}